## Sid Meier's Civilization 4
## Copyright Firaxis Games 2005
from CvPythonExtensions import *
import PyHelpers
import CvUtil
import ScreenInput
import CvScreenEnums

PyPlayer = PyHelpers.PyPlayer
PyCity = PyHelpers.PyCity

#	IMPORTANT INFORMATION
#	
#	All widget names MUST be unique when creating screens.  If you create
#	a widget named 'Hello', and then try to create another named 'Hello', it
#	will modify the first hello.
#
#	Also, when attaching widgets, 'Background' is a reserve word meant for
#	the background widget.  Do NOT use 'Background' to name any widget, but
#	when attaching to the background, please use the 'Background' keyword.

# globals
gc = CyGlobalContext()
ArtFileMgr = CyArtFileMgr()
localText = CyTranslator()

#	Set up the base Coordinates here...
STANDARD_Z = -2.2
TOP_Y = 96
Y_SPACING = 32
DATE_COLUMN = 70
NAME_COLUMN = DATE_COLUMN + 90
CULTURE_COLUMN = NAME_COLUMN + 130
HAPPY_COLUMN = CULTURE_COLUMN + 90
HEALTH_COLUMN = HAPPY_COLUMN + 100
FOOD_COLUMN = HEALTH_COLUMN + 40
PRODUCTION_COLUMN = FOOD_COLUMN + 40
GOLD_COLUMN = PRODUCTION_COLUMN + 40
GREATPEOPLE_COLUMN = GOLD_COLUMN + 40
PRODUCING_COLUMN = GREATPEOPLE_COLUMN + 170

# Sorting information
DATE = 0
NAME = 1
CULTURE = 2
HAPPY = 3
HEALTH = 4
FOOD = 5
PRODUCTION = 6
GOLD = 7
GREATPEOPLE = 8
PRODUCING = 9
POPULATION = 10
UNHAPPY = 11
ANGRY = 12
BAD_HEALTH = 13
CONSUMPTION = 14
SCIENCE = 15
CULTURE_RATE = 16
GREATPEOPLE_RATE = 17

# What are we sorting by?
iSortingBy = DATE
iSortingDown = True

# Listbox identifiers...
UNIT_CHOSEN = 0
BUILDING_CHOSEN = 1
PROJECT_CHOSEN = 2
PROCESS_CHOSEN = 3

class CvDomesticAdvisor:
	"Domestic Advisor Screen"
	# Screen construction function
	def interfaceScreen(self):

		# This will get the actual Player class into iPlayer
		iPlayer = PyPlayer(CyGame().getActivePlayer())
		
		# Create a new screen, called DomesticAdvisur, using the file CvDomesticAdvisor.py for input
		screen = CyGInterfaceScreen( "DomesticAdvisor", CvScreenEnums.DOMESTIC_ADVISOR )
		screen.setDimensions(screen.centerX(0), screen.centerY(0), 1024, 768)
		screen.showScreen(PopupStates.POPUPSTATE_IMMEDIATE, False)
	
		# Here we set the background widget and exit button, and we show the screen
		screen.addPanel( "DomesticAdvisorBG", u"", u"", True, False, 0, 29, 1024, 562, PanelStyles.PANEL_STYLE_MAIN )
		#screen.addDDSGFC( "DomesticAdvisorBG", ArtFileMgr.getInterfaceArtInfo("SCREEN_BG").getPath(), 0, 29, 1024, 592, WidgetTypes.WIDGET_GENERAL, -1, -1 )
		screen.setText("DomesticExit", "Background", localText.getText("TXT_KEY_PEDIA_SCREEN_EXIT", ()).upper(), CvUtil.FONT_RIGHT_JUSTIFY, 1012, 564, -0.1, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_CLOSE_SCREEN, -1, -1 )
	
		# Header...
		#szText = "<font=4>" + localText.getText("TXT_KEY_DOMESTIC_ADVISOR_TITLE", ()).upper() + "</font>"
		#screen.setLabel( "DomesticTitleHeader", "Background", szText, CvUtil.FONT_CENTER_JUSTIFY, 472, 40, STANDARD_Z, FontTypes.TITLE_FONT, WidgetTypes.WIDGET_GENERAL, -1, -1 )

		# Erase the flag?
		CyInterface().setDirty(InterfaceDirtyBits.MiscButtons_DIRTY_BIT, True)

		# Draw the city list...
		self.drawContents( )
		
	# headers...
	def drawHeaders( self ):

		# Get the screen and the player
		screen = CyGInterfaceScreen( "DomesticAdvisor", CvScreenEnums.DOMESTIC_ADVISOR )
		
		# Date Founded Column
		screen.setTableColumnHeader( "CityListBackground", 0, localText.getText("Date", ()).upper(), 100 )
		
		# Name Column
		screen.setTableColumnHeader( "CityListBackground", 1, localText.getText("City", ()).upper(), 112 )
		
                # Religions Column
                screen.setTableColumnHeader( "CityListBackground", 2, localText.getText("Religions", ()).upper(), 130 )

		# Population Column
		screen.setTableColumnHeader( "CityListBackground", 3, localText.getText("Pop", ()).upper(), 40 )
		
                # Garrison Column  
		screen.setTableColumnHeader( "CityListBackground", 4, CvUtil.getIcon('strength'), 30 )

		# Net Happiness Column
		screen.setTableColumnHeader( "CityListBackground", 5, CvUtil.getIcon('happy'), 30)

		# Food Turns to Growth
		screen.setTableColumnHeader( "CityListBackground", 6, unicode(CvUtil.getIcon('food')), 30)

		# Net Health Column
		screen.setTableColumnHeader( "CityListBackground", 7, unicode(CvUtil.getIcon('healthy')), 30 )
		
		# Production Column
		screen.setTableColumnHeader( "CityListBackground", 8, unicode(CvUtil.getIcon('production')), 40 )
		
		# Gold Column
		screen.setTableColumnHeader( "CityListBackground", 9, unicode(CvUtil.getIcon('gold')), 40 )

		# City Maintenance Column
		screen.setTableColumnHeader( "CityListBackground", 10, unicode(CvUtil.getIcon('badgold')), 30 )
		
		# Research Column
		szText = u"%c" %(gc.getCommerceInfo(CommerceTypes.COMMERCE_RESEARCH).getChar())
		screen.setTableColumnHeader( "CityListBackground", 11, szText, 40 )
		
		# Culture Column
		screen.setTableColumnHeader( "CityListBackground", 12, unicode(CvUtil.getIcon('culture')), 45 )
		
		# Culture Total Column
		screen.setTableColumnHeader( "CityListBackground", 13, localText.getText("TXT_KEY_TOTAL", ()).upper(), 55 )
		
		# Great Person Column
		screen.setTableColumnHeader( "CityListBackground", 14, unicode(CvUtil.getIcon('GREATPEOPLE')), 40 )
		
		# Great Person Progress Column
		screen.setTableColumnHeader( "CityListBackground", 15, localText.getText("TXT_KEY_TOTAL", ()).upper(), 45 )
		
		# Production Column
		screen.setTableColumnHeader( "CityListBackground", 16, localText.getText("TXT_KEY_DOMESTIC_ADVISOR_PRODUCING", ()).upper(), 110 )

                # Production Turns Remaining Column
                screen.setTableColumnHeader( "CityListBackground", 17, localText.getText("", ()).upper(), 58 )
	
	# Function to draw the contents of the cityList passed in
	def drawContents (self):
	
		# Get the screen and the player
		screen = CyGInterfaceScreen( "DomesticAdvisor", CvScreenEnums.DOMESTIC_ADVISOR )
		iPlayer = PyPlayer(CyGame().getActivePlayer())
		
		screen.moveToFront( "Background" )
		
		# Build the table	
		screen.addTableControlGFC( "CityListBackground", 18, 22, 42, 980, 490, True, False, 32, 32, TableStyles.TABLE_STYLE_STANDARD )
		screen.enableSelect( "CityListBackground", True )
		screen.enableSort( "CityListBackground" )

		# Loop through the cities
		cityList = iPlayer.getCityList()
		for i in range(len(cityList)):
			pLoopCity = PyCity( CyGame().getActivePlayer(), cityList[i].getID() )

			screen.appendTableRow( "CityListBackground" )
	
			screen.selectRow( "CityListBackground", i, True )
	
			# Founded date first...
			# City founded date... Landmarks System
			szIDText = "Date" + str(pLoopCity.getID())
			iTurnTime = pLoopCity.getGameTurnFounded()
			szFounded = unicode(CyGameTextMgr().getTimeStr(iTurnTime, false))
			if pLoopCity.isGovernmentCenter():
				if pLoopCity.isCapital():
					szFounded = szFounded + u"%c" %(CvUtil.getIcon('star'))
				else:
                                        szFounded = szFounded + u"%c" %(CvUtil.getIcon('silver star'))
                        ### add National Wonder Landmarks
                        iI = 0
                        for iI in range (64,75):   ### hard coded building id strings from xml
                                if pLoopCity.hasBuilding(iI):
                                        szFounded = szFounded + u"%c" %(CvUtil.getIcon('bullet'))
                        ### end National Wonder Landmarks
                        if pLoopCity.isPower():
                                szFounded = szFounded + u"%c" %(CvUtil.getIcon('power'))
                        if pLoopCity.isDisorder():
                                if pLoopCity.isOccupation():
                                        szFounded = szFounded + u"%c" %(CvUtil.getIcon('occupation'))
                                        szFounded = szFounded +":"
                                        szFounded = szFounded + unicode(pLoopCity.getOccupationTimer())
                                else:
                                        szFounded = szFounded + u"%c" %(CvUtil.getIcon('angrypop'))
			
		
			screen.setTableText( "CityListBackground", 0, i, szFounded, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
	
			# City name... Landmarks System
			szCityName = pLoopCity.getName()
#                        if pLoopCity.isGovernmentCenter():
#                                if pLoopCity.isCapital():
#                                        szCityName = szCityName + u"%c" %(CvUtil.getIcon('star'))
#                                else:
#                                        szCityName = szCityName + u"%c" %(CvUtil.getIcon('silver star'))
#                        ### add National Wonder Landmarks
#                        iI = 0
#                        for iI in range (64,75):   ### hard coded building id strings from xml
#                                if pLoopCity.hasBuilding(iI):
#                                        szCityName = szCityName + u"%c" %(CvUtil.getIcon('bullet'))
#                        ### end National Wonder Landmarks
#                        if pLoopCity.isPower():
#                                szCityName = szCityName + u"%c" %(CvUtil.getIcon('power'))
#                        if pLoopCity.isDisorder():
#                                if pLoopCity.isOccupation():
#                                        szCityName = szCityName + u"%c" %(CvUtil.getIcon('occupation'))
#                                        szCityName = szCityName +":"
#                                        szCityName = szCityName + unicode(pLoopCity.getOccupationTimer())
#                                else:
#                                        szCityName = szCityName + u"%c" %(CvUtil.getIcon('angrypop'))
##                        if pLoopCity.isWeLoveTheKingDay():
##                                szCityName = szCityName +u"%c" %(CvUtil.getIcon('happy'))
                        
			screen.setTableText( "CityListBackground", 1, i, szCityName, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
			
			# Religions...
			szReligions = ""
                        lHolyCity = pLoopCity.getHolyCity()
                        if lHolyCity:
                                iI = 0
                                for iI in range(len(lHolyCity)):
                                        szReligions = szReligions + u"%c" %(gc.getReligionInfo(lHolyCity[iI]).getHolyCityChar())
                        lReligions = pLoopCity.getReligions()
                        if lReligions:
                                iI = 0
                                for iI in range(len(lReligions)):
                                        if lReligions[iI] in lHolyCity:
                                                continue
                                        szReligions = szReligions + u"%c" %(gc.getReligionInfo(lReligions[iI]).getChar())

                        screen.setTableText( "CityListBackground", 2, i, szReligions, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

                        # Population
			screen.setTableInt( "CityListBackground", 3, i, unicode(pLoopCity.getPopulation()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
	
			# Garrison
			screen.setTableInt( "CityListBackground", 4, i, unicode(pLoopCity.getMilitaryHappinessUnits()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

                        # Replace Happiness/Unhappiness with Net Happiness...
                        szHappiness = ""
                        iHappiness = (pLoopCity.getHappyPopulation() - pLoopCity.getUnhappyPopulation())
                        if iHappiness >= 0:
                                szHappiness = szHappiness + unicode(pLoopCity.getHappyPopulation() - pLoopCity.getUnhappyPopulation())
                        else:
                                szHappiness = szHappiness + u"%c" %(CvUtil.getIcon('unhappy'))

                        screen.setTableInt( "CityListBackground", 5, i, szHappiness, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
                        
			# combine Food/consumed to Turns til Growth
			iGrowth = pLoopCity.getFoodRate() - pLoopCity.foodConsumption(False, 0)
			szGrowth = ""
			if iGrowth > 0:
                                szGrowth = szGrowth + unicode(pLoopCity.getFoodTurnsLeft())
			if iGrowth == 0:
                                szGrowth = szGrowth + unicode(iGrowth)
			if iGrowth < 0:
                                szGrowth = szGrowth + u"%c" %(CvUtil.getIcon('badfood'))

                        screen.setTableInt( "CityListBackground", 6, i, szGrowth, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
			
			# combine health/unhealthy... to Net City Health
			iHealth = pLoopCity.getGoodHealth() - pLoopCity.getBadHealth()
			szHealth = ""
			if iHealth < 0:
                                szHealth = szHealth + u"%c" %(CvUtil.getIcon('unhealthy'))
                        else:
                                szHealth = szHealth + unicode(pLoopCity.getGoodHealth() - pLoopCity.getBadHealth())

                        screen.setTableInt( "CityListBackground", 7, i, szHealth, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Production status... displays "base" production, with no modifiers
			screen.setTableInt( "CityListBackground", 8, i, unicode(pLoopCity.getProductionRate()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
	
			# Gold status... displays "base" commerce, with no modifiers
			screen.setTableInt( "CityListBackground", 9, i, unicode(pLoopCity.calculateGoldRate()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

                        # City Maintanance...
                        screen.setTableInt( "CityListBackground", 10, i, unicode(pLoopCity.getMaintenance()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Science rate...
			screen.setTableInt( "CityListBackground", 11, i, unicode(pLoopCity.getResearchRate()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Culture status...
			screen.setTableInt( "CityListBackground", 12, i, unicode(pLoopCity.getCultureCommerce()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Total Culture			
			screen.setTableInt( "CityListBackground", 13, i, unicode(pLoopCity.getCulture()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Great Person
			screen.setTableInt( "CityListBackground", 14, i, unicode(pLoopCity.getGreatPeopleRate()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Great Person
			screen.setTableInt( "CityListBackground", 15, i, unicode(pLoopCity.getGreatPeopleProgress()), "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

			# Producing
                        iProducing = pLoopCity.getProductionName()
			screen.setTableText( "CityListBackground", 16, i, iProducing, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )

                        # Producing Turns Left
                        iTurns = ""
                        iI = 0
                        for iI in range( gc.getNumUnitClassInfos() ) :
                                eUnitType = iPlayer.getCivilizationInfo().getCivilizationUnits(iI)
                                if iProducing == gc.getUnitInfo(eUnitType).getDescription() :
                                        iTurns = unicode(pLoopCity.getProductionTurnsLeft())
                                        
                        for iI in range ( gc.getNumBuildingClassInfos() ) :
                                eBuilding = iPlayer.getCivilizationInfo().getCivilizationBuildings(iI)
                                if iProducing == gc.getBuildingInfo(eBuilding).getDescription() :
                                        iTurns = unicode(pLoopCity.getProductionTurnsLeft())

                        for iI in range (gc.getNumProjectInfos() ):
                                if iProducing == gc.getProjectInfo(iI).getDescription() :
                                        iTurns = unicode(pLoopCity.getProductionTurnsLeft())

                        for iI in range (gc.getNumProcessInfos() ):
                                if iProducing == gc.getProcessInfo(iI).getDescription() :
                                        iTurns = ""

                        screen.setTableInt( "CityListBackground", 17, i, iTurns, "", WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY )
	
		self.drawHeaders()
		
		screen.moveToBack( "DomesticAdvisorBG" )
		
		screen.updateAppropriateCitySelection( "CityListBackground", len( PyPlayer(CyGame().getActivePlayer()).getCityList() ) )
		

	# Will handle the input for this screen...
	def handleInput (self, inputClass):
		' Calls function mapped in DomesticAdvisorInputMap'
		# only get from the map if it has the key
		
		if ( inputClass.getNotifyCode() == NotifyCode.NOTIFY_LISTBOX_ITEM_SELECTED ):
			screen = CyGInterfaceScreen( "DomesticAdvisor", CvScreenEnums.DOMESTIC_ADVISOR )
			screen.updateAppropriateCitySelection( "CityListBackground", len( PyPlayer(CyGame().getActivePlayer()).getCityList() ) )
			
		return 0
	
	def updateScreen(self):
		
		screen = CyGInterfaceScreen( "DomesticAdvisor", CvScreenEnums.DOMESTIC_ADVISOR )
		iPlayer = PyPlayer(CyGame().getActivePlayer())

		cityList = iPlayer.getCityList()
		for i in range(len(cityList)):
		
			pLoopCity = PyCity( CyGame().getActivePlayer(), cityList[i].getID() )

			# Update Producing
			screen.setTableTextKey( "CityListBackground", 17, pLoopCity.getName(), 1, unicode(pLoopCity.getProductionName()), WidgetTypes.WIDGET_GENERAL, -1, -1, CvUtil.FONT_LEFT_JUSTIFY, len(cityList) )
	
		return
		
	def update(self, fDelta):
	
		return
